/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ExtendedLocationType;
import com.azure.resourcemanager.compute.models.ResourceSkuZoneDetails;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuLocationInfo
implements JsonSerializable<ResourceSkuLocationInfo> {
    private String location;
    private List<String> zones;
    private List<ResourceSkuZoneDetails> zoneDetails;
    private List<String> extendedLocations;
    private ExtendedLocationType type;

    public String location() {
        return this.location;
    }

    public List<String> zones() {
        return this.zones;
    }

    public List<ResourceSkuZoneDetails> zoneDetails() {
        return this.zoneDetails;
    }

    public List<String> extendedLocations() {
        return this.extendedLocations;
    }

    public ExtendedLocationType type() {
        return this.type;
    }

    public void validate() {
        if (this.zoneDetails() != null) {
            this.zoneDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuLocationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkuLocationInfo)jsonReader.readObject(reader -> {
            ResourceSkuLocationInfo deserializedResourceSkuLocationInfo = new ResourceSkuLocationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedResourceSkuLocationInfo.location = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedResourceSkuLocationInfo.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("zoneDetails".equals(fieldName)) {
                    List zoneDetails;
                    deserializedResourceSkuLocationInfo.zoneDetails = zoneDetails = reader.readArray(reader1 -> ResourceSkuZoneDetails.fromJson(reader1));
                    continue;
                }
                if ("extendedLocations".equals(fieldName)) {
                    List extendedLocations;
                    deserializedResourceSkuLocationInfo.extendedLocations = extendedLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceSkuLocationInfo.type = ExtendedLocationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuLocationInfo;
        });
    }
}

