/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.GalleryInVMAccessControlProfilesClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileList;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GalleryInVMAccessControlProfilesClientImpl
implements GalleryInVMAccessControlProfilesClient {
    private final GalleryInVMAccessControlProfilesService service;
    private final ComputeManagementClientImpl client;

    GalleryInVMAccessControlProfilesClientImpl(ComputeManagementClientImpl client) {
        this.service = (GalleryInVMAccessControlProfilesService)RestProxy.create(GalleryInVMAccessControlProfilesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        }
        galleryInVMAccessControlProfile.validate();
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", galleryInVMAccessControlProfile, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        }
        galleryInVMAccessControlProfile.validate();
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", galleryInVMAccessControlProfile, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileInner.class), (Type)((Object)GalleryInVMAccessControlProfileInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileInner.class), (Type)((Object)GalleryInVMAccessControlProfileInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner createOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        return (GalleryInVMAccessControlProfileInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner createOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        return (GalleryInVMAccessControlProfileInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        }
        galleryInVMAccessControlProfile.validate();
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", galleryInVMAccessControlProfile, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        }
        galleryInVMAccessControlProfile.validate();
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", galleryInVMAccessControlProfile, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileInner.class), (Type)((Object)GalleryInVMAccessControlProfileInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileInner.class), (Type)((Object)GalleryInVMAccessControlProfileInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileInner> updateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileInner> updateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner update(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        return (GalleryInVMAccessControlProfileInner)((Object)this.updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner update(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        return (GalleryInVMAccessControlProfileInner)((Object)this.updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, galleryInVMAccessControlProfile, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GalleryInVMAccessControlProfileInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GalleryInVMAccessControlProfileInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileInner> getAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return this.getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GalleryInVMAccessControlProfileInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GalleryInVMAccessControlProfileInner> getWithResponse(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner get(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return (GalleryInVMAccessControlProfileInner)((Object)this.getWithResponse(resourceGroupName, galleryName, inVMAccessControlProfileName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "2024-03-03", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        this.deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        this.deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>> listByGallerySinglePageAsync(String resourceGroupName, String galleryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGallery(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, "2024-03-03", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileList)res.getValue()).value(), ((GalleryInVMAccessControlProfileList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>> listByGallerySinglePageAsync(String resourceGroupName, String galleryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        String apiVersion = "2024-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGallery(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, "2024-03-03", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileList)res.getValue()).value(), ((GalleryInVMAccessControlProfileList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GalleryInVMAccessControlProfileInner> listByGalleryAsync(String resourceGroupName, String galleryName) {
        return new PagedFlux(() -> this.listByGallerySinglePageAsync(resourceGroupName, galleryName), nextLink -> this.listByGalleryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GalleryInVMAccessControlProfileInner> listByGalleryAsync(String resourceGroupName, String galleryName, Context context) {
        return new PagedFlux(() -> this.listByGallerySinglePageAsync(resourceGroupName, galleryName, context), nextLink -> this.listByGalleryNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileInner> listByGallery(String resourceGroupName, String galleryName) {
        return new PagedIterable(this.listByGalleryAsync(resourceGroupName, galleryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileInner> listByGallery(String resourceGroupName, String galleryName, Context context) {
        return new PagedIterable(this.listByGalleryAsync(resourceGroupName, galleryName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>> listByGalleryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileList)res.getValue()).value(), ((GalleryInVMAccessControlProfileList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>> listByGalleryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileList)res.getValue()).value(), ((GalleryInVMAccessControlProfileList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface GalleryInVMAccessControlProfilesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="inVMAccessControlProfileName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") GalleryInVMAccessControlProfileInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="inVMAccessControlProfileName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") GalleryInVMAccessControlProfileUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryInVMAccessControlProfileInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="inVMAccessControlProfileName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @PathParam(value="inVMAccessControlProfileName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryInVMAccessControlProfileList>> listByGallery(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryInVMAccessControlProfileList>> listByGalleryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

