/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetProperties;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class AvailabilitySetUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AvailabilitySetUpdate.class);
    @JsonProperty(value="properties")
    private AvailabilitySetProperties innerProperties;
    @JsonProperty(value="sku")
    private Sku sku;

    private AvailabilitySetProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public AvailabilitySetUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public AvailabilitySetUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer platformUpdateDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformUpdateDomainCount();
    }

    public AvailabilitySetUpdate withPlatformUpdateDomainCount(Integer platformUpdateDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withPlatformUpdateDomainCount(platformUpdateDomainCount);
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomainCount();
    }

    public AvailabilitySetUpdate withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withPlatformFaultDomainCount(platformFaultDomainCount);
        return this;
    }

    public List<SubResource> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    public AvailabilitySetUpdate withVirtualMachines(List<SubResource> virtualMachines) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withVirtualMachines(virtualMachines);
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    public AvailabilitySetUpdate withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AvailabilitySetProperties();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.innerProperties() == null ? null : this.innerProperties().statuses();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

