/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecretParameters;
import com.azure.resourcemanager.cdn.models.SecretType;
import java.io.IOException;

public final class UrlSigningKeyParameters
extends SecretParameters {
    private SecretType type = SecretType.URL_SIGNING_KEY;
    private String keyId;
    private ResourceReference secretSource;
    private String secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningKeyParameters.class);

    @Override
    public SecretType type() {
        return this.type;
    }

    public String keyId() {
        return this.keyId;
    }

    public UrlSigningKeyParameters withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public UrlSigningKeyParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public UrlSigningKeyParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.keyId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyId in model UrlSigningKeyParameters"));
        }
        if (this.secretSource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretSource in model UrlSigningKeyParameters"));
        }
        this.secretSource().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("secretSource", (JsonSerializable)this.secretSource);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    public static UrlSigningKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (UrlSigningKeyParameters)jsonReader.readObject(reader -> {
            UrlSigningKeyParameters deserializedUrlSigningKeyParameters = new UrlSigningKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyId".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.keyId = reader.getString();
                    continue;
                }
                if ("secretSource".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.secretSource = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.type = SecretType.fromString(reader.getString());
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.secretVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlSigningKeyParameters;
        });
    }
}

