/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ActivatedResourceReference;
import java.io.IOException;
import java.util.List;

public final class SecurityPolicyWebApplicationFirewallAssociation
implements JsonSerializable<SecurityPolicyWebApplicationFirewallAssociation> {
    private List<ActivatedResourceReference> domains;
    private List<String> patternsToMatch;

    public List<ActivatedResourceReference> domains() {
        return this.domains;
    }

    public SecurityPolicyWebApplicationFirewallAssociation withDomains(List<ActivatedResourceReference> domains) {
        this.domains = domains;
        return this;
    }

    public List<String> patternsToMatch() {
        return this.patternsToMatch;
    }

    public SecurityPolicyWebApplicationFirewallAssociation withPatternsToMatch(List<String> patternsToMatch) {
        this.patternsToMatch = patternsToMatch;
        return this;
    }

    public void validate() {
        if (this.domains() != null) {
            this.domains().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("domains", this.domains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("patternsToMatch", this.patternsToMatch, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SecurityPolicyWebApplicationFirewallAssociation fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityPolicyWebApplicationFirewallAssociation)jsonReader.readObject(reader -> {
            SecurityPolicyWebApplicationFirewallAssociation deserializedSecurityPolicyWebApplicationFirewallAssociation = new SecurityPolicyWebApplicationFirewallAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domains".equals(fieldName)) {
                    List domains;
                    deserializedSecurityPolicyWebApplicationFirewallAssociation.domains = domains = reader.readArray(reader1 -> ActivatedResourceReference.fromJson(reader1));
                    continue;
                }
                if ("patternsToMatch".equals(fieldName)) {
                    List patternsToMatch;
                    deserializedSecurityPolicyWebApplicationFirewallAssociation.patternsToMatch = patternsToMatch = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPolicyWebApplicationFirewallAssociation;
        });
    }
}

