/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ActionType;
import com.azure.resourcemanager.cdn.models.CustomRule;
import com.azure.resourcemanager.cdn.models.CustomRuleEnabledState;
import com.azure.resourcemanager.cdn.models.MatchCondition;
import java.io.IOException;
import java.util.List;

public final class RateLimitRule
extends CustomRule {
    private int rateLimitThreshold;
    private int rateLimitDurationInMinutes;

    public int rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    public RateLimitRule withRateLimitThreshold(int rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    public int rateLimitDurationInMinutes() {
        return this.rateLimitDurationInMinutes;
    }

    public RateLimitRule withRateLimitDurationInMinutes(int rateLimitDurationInMinutes) {
        this.rateLimitDurationInMinutes = rateLimitDurationInMinutes;
        return this;
    }

    @Override
    public RateLimitRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public RateLimitRule withEnabledState(CustomRuleEnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    @Override
    public RateLimitRule withPriority(int priority) {
        super.withPriority(priority);
        return this;
    }

    @Override
    public RateLimitRule withMatchConditions(List<MatchCondition> matchConditions) {
        super.withMatchConditions(matchConditions);
        return this;
    }

    @Override
    public RateLimitRule withAction(ActionType action) {
        super.withAction(action);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeIntField("priority", this.priority());
        jsonWriter.writeArrayField("matchConditions", this.matchConditions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("action", this.action() == null ? null : this.action().toString());
        jsonWriter.writeStringField("enabledState", this.enabledState() == null ? null : this.enabledState().toString());
        jsonWriter.writeIntField("rateLimitThreshold", this.rateLimitThreshold);
        jsonWriter.writeIntField("rateLimitDurationInMinutes", this.rateLimitDurationInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static RateLimitRule fromJson(JsonReader jsonReader) throws IOException {
        return (RateLimitRule)jsonReader.readObject(reader -> {
            RateLimitRule deserializedRateLimitRule = new RateLimitRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRateLimitRule.withName(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedRateLimitRule.withPriority(reader.getInt());
                    continue;
                }
                if ("matchConditions".equals(fieldName)) {
                    List matchConditions = reader.readArray(reader1 -> MatchCondition.fromJson(reader1));
                    deserializedRateLimitRule.withMatchConditions(matchConditions);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedRateLimitRule.withAction(ActionType.fromString(reader.getString()));
                    continue;
                }
                if ("enabledState".equals(fieldName)) {
                    deserializedRateLimitRule.withEnabledState(CustomRuleEnabledState.fromString(reader.getString()));
                    continue;
                }
                if ("rateLimitThreshold".equals(fieldName)) {
                    deserializedRateLimitRule.rateLimitThreshold = reader.getInt();
                    continue;
                }
                if ("rateLimitDurationInMinutes".equals(fieldName)) {
                    deserializedRateLimitRule.rateLimitDurationInMinutes = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRateLimitRule;
        });
    }
}

