/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SharedPrivateLinkResourceProperties;
import java.io.IOException;

public class AfdOriginUpdatePropertiesParameters
implements JsonSerializable<AfdOriginUpdatePropertiesParameters> {
    private String originGroupName;
    private ResourceReference azureOrigin;
    private String hostname;
    private Integer httpPort;
    private Integer httpsPort;
    private String originHostHeader;
    private Integer priority;
    private Integer weight;
    private SharedPrivateLinkResourceProperties sharedPrivateLinkResource;
    private EnabledState enabledState;
    private Boolean enforceCertificateNameCheck;

    public String originGroupName() {
        return this.originGroupName;
    }

    AfdOriginUpdatePropertiesParameters withOriginGroupName(String originGroupName) {
        this.originGroupName = originGroupName;
        return this;
    }

    public ResourceReference azureOrigin() {
        return this.azureOrigin;
    }

    public AfdOriginUpdatePropertiesParameters withAzureOrigin(ResourceReference azureOrigin) {
        this.azureOrigin = azureOrigin;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public AfdOriginUpdatePropertiesParameters withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public AfdOriginUpdatePropertiesParameters withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public AfdOriginUpdatePropertiesParameters withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String originHostHeader() {
        return this.originHostHeader;
    }

    public AfdOriginUpdatePropertiesParameters withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public AfdOriginUpdatePropertiesParameters withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Integer weight() {
        return this.weight;
    }

    public AfdOriginUpdatePropertiesParameters withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public SharedPrivateLinkResourceProperties sharedPrivateLinkResource() {
        return this.sharedPrivateLinkResource;
    }

    public AfdOriginUpdatePropertiesParameters withSharedPrivateLinkResource(SharedPrivateLinkResourceProperties sharedPrivateLinkResource) {
        this.sharedPrivateLinkResource = sharedPrivateLinkResource;
        return this;
    }

    public EnabledState enabledState() {
        return this.enabledState;
    }

    public AfdOriginUpdatePropertiesParameters withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public Boolean enforceCertificateNameCheck() {
        return this.enforceCertificateNameCheck;
    }

    public AfdOriginUpdatePropertiesParameters withEnforceCertificateNameCheck(Boolean enforceCertificateNameCheck) {
        this.enforceCertificateNameCheck = enforceCertificateNameCheck;
        return this;
    }

    public void validate() {
        if (this.azureOrigin() != null) {
            this.azureOrigin().validate();
        }
        if (this.sharedPrivateLinkResource() != null) {
            this.sharedPrivateLinkResource().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureOrigin", (JsonSerializable)this.azureOrigin);
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeNumberField("httpPort", (Number)this.httpPort);
        jsonWriter.writeNumberField("httpsPort", (Number)this.httpsPort);
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeNumberField("weight", (Number)this.weight);
        jsonWriter.writeJsonField("sharedPrivateLinkResource", (JsonSerializable)this.sharedPrivateLinkResource);
        jsonWriter.writeStringField("enabledState", this.enabledState == null ? null : this.enabledState.toString());
        jsonWriter.writeBooleanField("enforceCertificateNameCheck", this.enforceCertificateNameCheck);
        return jsonWriter.writeEndObject();
    }

    public static AfdOriginUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AfdOriginUpdatePropertiesParameters)jsonReader.readObject(reader -> {
            AfdOriginUpdatePropertiesParameters deserializedAfdOriginUpdatePropertiesParameters = new AfdOriginUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originGroupName".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.originGroupName = reader.getString();
                    continue;
                }
                if ("azureOrigin".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.azureOrigin = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.hostname = reader.getString();
                    continue;
                }
                if ("httpPort".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.httpPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpsPort".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.httpsPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.originHostHeader = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.weight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sharedPrivateLinkResource".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.sharedPrivateLinkResource = SharedPrivateLinkResourceProperties.fromJson(reader);
                    continue;
                }
                if ("enabledState".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.enabledState = EnabledState.fromString(reader.getString());
                    continue;
                }
                if ("enforceCertificateNameCheck".equals(fieldName)) {
                    deserializedAfdOriginUpdatePropertiesParameters.enforceCertificateNameCheck = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAfdOriginUpdatePropertiesParameters;
        });
    }
}

