/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.DateRange;
import com.azure.resourcemanager.carbonoptimization.models.EmissionScopeEnum;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.ReportTypeEnum;
import java.io.IOException;
import java.util.List;

public final class TopItemsSummaryReportQueryFilter
extends QueryFilter {
    private ReportTypeEnum reportType = ReportTypeEnum.TOP_ITEMS_SUMMARY_REPORT;
    private CategoryTypeEnum categoryType;
    private int topItems;
    private static final ClientLogger LOGGER = new ClientLogger(TopItemsSummaryReportQueryFilter.class);

    @Override
    public ReportTypeEnum reportType() {
        return this.reportType;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public TopItemsSummaryReportQueryFilter withCategoryType(CategoryTypeEnum categoryType) {
        this.categoryType = categoryType;
        return this;
    }

    public int topItems() {
        return this.topItems;
    }

    public TopItemsSummaryReportQueryFilter withTopItems(int topItems) {
        this.topItems = topItems;
        return this;
    }

    @Override
    public TopItemsSummaryReportQueryFilter withDateRange(DateRange dateRange) {
        super.withDateRange(dateRange);
        return this;
    }

    @Override
    public TopItemsSummaryReportQueryFilter withSubscriptionList(List<String> subscriptionList) {
        super.withSubscriptionList(subscriptionList);
        return this;
    }

    @Override
    public TopItemsSummaryReportQueryFilter withResourceGroupUrlList(List<String> resourceGroupUrlList) {
        super.withResourceGroupUrlList(resourceGroupUrlList);
        return this;
    }

    @Override
    public TopItemsSummaryReportQueryFilter withResourceTypeList(List<String> resourceTypeList) {
        super.withResourceTypeList(resourceTypeList);
        return this;
    }

    @Override
    public TopItemsSummaryReportQueryFilter withLocationList(List<String> locationList) {
        super.withLocationList(locationList);
        return this;
    }

    @Override
    public TopItemsSummaryReportQueryFilter withCarbonScopeList(List<EmissionScopeEnum> carbonScopeList) {
        super.withCarbonScopeList(carbonScopeList);
        return this;
    }

    @Override
    public void validate() {
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model TopItemsSummaryReportQueryFilter"));
        }
        if (this.dateRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dateRange in model TopItemsSummaryReportQueryFilter"));
        }
        this.dateRange().validate();
        if (this.subscriptionList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionList in model TopItemsSummaryReportQueryFilter"));
        }
        if (this.carbonScopeList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property carbonScopeList in model TopItemsSummaryReportQueryFilter"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateRange", (JsonSerializable)this.dateRange());
        jsonWriter.writeArrayField("subscriptionList", this.subscriptionList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("carbonScopeList", this.carbonScopeList(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("resourceGroupUrlList", this.resourceGroupUrlList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("resourceTypeList", this.resourceTypeList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationList", this.locationList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeIntField("topItems", this.topItems);
        jsonWriter.writeStringField("reportType", this.reportType == null ? null : this.reportType.toString());
        return jsonWriter.writeEndObject();
    }

    public static TopItemsSummaryReportQueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (TopItemsSummaryReportQueryFilter)jsonReader.readObject(reader -> {
            TopItemsSummaryReportQueryFilter deserializedTopItemsSummaryReportQueryFilter = new TopItemsSummaryReportQueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateRange".equals(fieldName)) {
                    deserializedTopItemsSummaryReportQueryFilter.withDateRange(DateRange.fromJson(reader));
                    continue;
                }
                if ("subscriptionList".equals(fieldName)) {
                    List subscriptionList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsSummaryReportQueryFilter.withSubscriptionList(subscriptionList);
                    continue;
                }
                if ("carbonScopeList".equals(fieldName)) {
                    List carbonScopeList = reader.readArray(reader1 -> EmissionScopeEnum.fromString(reader1.getString()));
                    deserializedTopItemsSummaryReportQueryFilter.withCarbonScopeList(carbonScopeList);
                    continue;
                }
                if ("resourceGroupUrlList".equals(fieldName)) {
                    List resourceGroupUrlList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsSummaryReportQueryFilter.withResourceGroupUrlList(resourceGroupUrlList);
                    continue;
                }
                if ("resourceTypeList".equals(fieldName)) {
                    List resourceTypeList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsSummaryReportQueryFilter.withResourceTypeList(resourceTypeList);
                    continue;
                }
                if ("locationList".equals(fieldName)) {
                    List locationList = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopItemsSummaryReportQueryFilter.withLocationList(locationList);
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedTopItemsSummaryReportQueryFilter.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("topItems".equals(fieldName)) {
                    deserializedTopItemsSummaryReportQueryFilter.topItems = reader.getInt();
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    deserializedTopItemsSummaryReportQueryFilter.reportType = ReportTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopItemsSummaryReportQueryFilter;
        });
    }
}

