/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.AccessDecisionEnum;
import java.io.IOException;

public final class SubscriptionAccessDecision
implements JsonSerializable<SubscriptionAccessDecision> {
    private String subscriptionId;
    private AccessDecisionEnum decision;
    private String denialReason;
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionAccessDecision.class);

    private SubscriptionAccessDecision() {
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public AccessDecisionEnum decision() {
        return this.decision;
    }

    public String denialReason() {
        return this.denialReason;
    }

    public void validate() {
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model SubscriptionAccessDecision"));
        }
        if (this.decision() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property decision in model SubscriptionAccessDecision"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("decision", this.decision == null ? null : this.decision.toString());
        jsonWriter.writeStringField("denialReason", this.denialReason);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionAccessDecision fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionAccessDecision)jsonReader.readObject(reader -> {
            SubscriptionAccessDecision deserializedSubscriptionAccessDecision = new SubscriptionAccessDecision();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionId".equals(fieldName)) {
                    deserializedSubscriptionAccessDecision.subscriptionId = reader.getString();
                    continue;
                }
                if ("decision".equals(fieldName)) {
                    deserializedSubscriptionAccessDecision.decision = AccessDecisionEnum.fromString(reader.getString());
                    continue;
                }
                if ("denialReason".equals(fieldName)) {
                    deserializedSubscriptionAccessDecision.denialReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionAccessDecision;
        });
    }
}

