/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class ResourceCarbonEmissionTopItemsSummaryData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.RESOURCE_TOP_ITEMS_SUMMARY_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private String subscriptionId;
    private String resourceGroup;
    private String resourceId;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceCarbonEmissionTopItemsSummaryData.class);

    private ResourceCarbonEmissionTopItemsSummaryData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public String resourceId() {
        return this.resourceId;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model ResourceCarbonEmissionTopItemsSummaryData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model ResourceCarbonEmissionTopItemsSummaryData"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model ResourceCarbonEmissionTopItemsSummaryData"));
        }
        if (this.resourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroup in model ResourceCarbonEmissionTopItemsSummaryData"));
        }
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model ResourceCarbonEmissionTopItemsSummaryData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceCarbonEmissionTopItemsSummaryData fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceCarbonEmissionTopItemsSummaryData)jsonReader.readObject(reader -> {
            ResourceCarbonEmissionTopItemsSummaryData deserializedResourceCarbonEmissionTopItemsSummaryData = new ResourceCarbonEmissionTopItemsSummaryData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.resourceGroup = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.resourceId = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemsSummaryData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceCarbonEmissionTopItemsSummaryData;
        });
    }
}

