/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class ResourceCarbonEmissionItemDetailData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.RESOURCE_ITEM_DETAILS_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private String subscriptionId;
    private String resourceGroup;
    private String resourceId;
    private String location;
    private String resourceType;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceCarbonEmissionItemDetailData.class);

    private ResourceCarbonEmissionItemDetailData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String location() {
        return this.location;
    }

    public String resourceType() {
        return this.resourceType;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model ResourceCarbonEmissionItemDetailData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model ResourceCarbonEmissionItemDetailData"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model ResourceCarbonEmissionItemDetailData"));
        }
        if (this.resourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroup in model ResourceCarbonEmissionItemDetailData"));
        }
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model ResourceCarbonEmissionItemDetailData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        return jsonWriter.writeEndObject();
    }

    public static ResourceCarbonEmissionItemDetailData fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceCarbonEmissionItemDetailData)jsonReader.readObject(reader -> {
            ResourceCarbonEmissionItemDetailData deserializedResourceCarbonEmissionItemDetailData = new ResourceCarbonEmissionItemDetailData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.resourceGroup = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.resourceId = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.location = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionItemDetailData.resourceType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceCarbonEmissionItemDetailData;
        });
    }
}

