/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.SubscriptionAccessDecision;
import java.io.IOException;
import java.util.List;

public final class CarbonEmissionDataListResultInner
implements JsonSerializable<CarbonEmissionDataListResultInner> {
    private List<CarbonEmissionData> value;
    private String skipToken;
    private List<SubscriptionAccessDecision> subscriptionAccessDecisionList;
    private static final ClientLogger LOGGER = new ClientLogger(CarbonEmissionDataListResultInner.class);

    private CarbonEmissionDataListResultInner() {
    }

    public List<CarbonEmissionData> value() {
        return this.value;
    }

    public String skipToken() {
        return this.skipToken;
    }

    public List<SubscriptionAccessDecision> subscriptionAccessDecisionList() {
        return this.subscriptionAccessDecisionList;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CarbonEmissionDataListResultInner"));
        }
        this.value().forEach(e -> e.validate());
        if (this.subscriptionAccessDecisionList() != null) {
            this.subscriptionAccessDecisionList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("skipToken", this.skipToken);
        jsonWriter.writeArrayField("subscriptionAccessDecisionList", this.subscriptionAccessDecisionList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CarbonEmissionDataListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionDataListResultInner)jsonReader.readObject(reader -> {
            CarbonEmissionDataListResultInner deserializedCarbonEmissionDataListResultInner = new CarbonEmissionDataListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCarbonEmissionDataListResultInner.value = value = reader.readArray(reader1 -> CarbonEmissionData.fromJson(reader1));
                    continue;
                }
                if ("skipToken".equals(fieldName)) {
                    deserializedCarbonEmissionDataListResultInner.skipToken = reader.getString();
                    continue;
                }
                if ("subscriptionAccessDecisionList".equals(fieldName)) {
                    List subscriptionAccessDecisionList;
                    deserializedCarbonEmissionDataListResultInner.subscriptionAccessDecisionList = subscriptionAccessDecisionList = reader.readArray(reader1 -> SubscriptionAccessDecision.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCarbonEmissionDataListResultInner;
        });
    }
}

