/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class ResourceGroupCarbonEmissionTopItemMonthlySummaryData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.RESOURCE_GROUP_TOP_ITEMS_MONTHLY_SUMMARY_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private String date;
    private String subscriptionId;
    private String resourceGroupUrl;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceGroupCarbonEmissionTopItemMonthlySummaryData.class);

    private ResourceGroupCarbonEmissionTopItemMonthlySummaryData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public String date() {
        return this.date;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroupUrl() {
        return this.resourceGroupUrl;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model ResourceGroupCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model ResourceGroupCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.date() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property date in model ResourceGroupCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model ResourceGroupCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.resourceGroupUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroupUrl in model ResourceGroupCarbonEmissionTopItemMonthlySummaryData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("date", this.date);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroupUrl", this.resourceGroupUrl);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceGroupCarbonEmissionTopItemMonthlySummaryData fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGroupCarbonEmissionTopItemMonthlySummaryData)jsonReader.readObject(reader -> {
            ResourceGroupCarbonEmissionTopItemMonthlySummaryData deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData = new ResourceGroupCarbonEmissionTopItemMonthlySummaryData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("date".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.date = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroupUrl".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.resourceGroupUrl = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGroupCarbonEmissionTopItemMonthlySummaryData;
        });
    }
}

