/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class ResourceGroupCarbonEmissionItemDetailData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.RESOURCE_GROUP_ITEM_DETAILS_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private String subscriptionId;
    private String resourceGroupUrl;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceGroupCarbonEmissionItemDetailData.class);

    private ResourceGroupCarbonEmissionItemDetailData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroupUrl() {
        return this.resourceGroupUrl;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model ResourceGroupCarbonEmissionItemDetailData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model ResourceGroupCarbonEmissionItemDetailData"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model ResourceGroupCarbonEmissionItemDetailData"));
        }
        if (this.resourceGroupUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroupUrl in model ResourceGroupCarbonEmissionItemDetailData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroupUrl", this.resourceGroupUrl);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceGroupCarbonEmissionItemDetailData fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGroupCarbonEmissionItemDetailData)jsonReader.readObject(reader -> {
            ResourceGroupCarbonEmissionItemDetailData deserializedResourceGroupCarbonEmissionItemDetailData = new ResourceGroupCarbonEmissionItemDetailData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroupUrl".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.resourceGroupUrl = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedResourceGroupCarbonEmissionItemDetailData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGroupCarbonEmissionItemDetailData;
        });
    }
}

