/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class ResourceCarbonEmissionTopItemMonthlySummaryData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.RESOURCE_TOP_ITEMS_MONTHLY_SUMMARY_DATA;
    private String itemName;
    private CategoryTypeEnum categoryType;
    private String date;
    private String subscriptionId;
    private String resourceGroup;
    private String resourceId;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceCarbonEmissionTopItemMonthlySummaryData.class);

    private ResourceCarbonEmissionTopItemMonthlySummaryData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    public String itemName() {
        return this.itemName;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public String date() {
        return this.date;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public String resourceId() {
        return this.resourceId;
    }

    @Override
    public void validate() {
        if (this.itemName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property itemName in model ResourceCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model ResourceCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.date() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property date in model ResourceCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model ResourceCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.resourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroup in model ResourceCarbonEmissionTopItemMonthlySummaryData"));
        }
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model ResourceCarbonEmissionTopItemMonthlySummaryData"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("itemName", this.itemName);
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("date", this.date);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceCarbonEmissionTopItemMonthlySummaryData fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceCarbonEmissionTopItemMonthlySummaryData)jsonReader.readObject(reader -> {
            ResourceCarbonEmissionTopItemMonthlySummaryData deserializedResourceCarbonEmissionTopItemMonthlySummaryData = new ResourceCarbonEmissionTopItemMonthlySummaryData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("itemName".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.itemName = reader.getString();
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("date".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.date = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.resourceGroup = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.resourceId = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedResourceCarbonEmissionTopItemMonthlySummaryData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceCarbonEmissionTopItemMonthlySummaryData;
        });
    }
}

