/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.DateRange;
import com.azure.resourcemanager.carbonoptimization.models.EmissionScopeEnum;
import com.azure.resourcemanager.carbonoptimization.models.ItemDetailsQueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.MonthlySummaryReportQueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.OverallSummaryReportQueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.ReportTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.TopItemsMonthlySummaryReportQueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.TopItemsSummaryReportQueryFilter;
import java.io.IOException;
import java.util.List;

public class QueryFilter
implements JsonSerializable<QueryFilter> {
    private ReportTypeEnum reportType = ReportTypeEnum.fromString("QueryFilter");
    private DateRange dateRange;
    private List<String> subscriptionList;
    private List<String> resourceGroupUrlList;
    private List<String> resourceTypeList;
    private List<String> locationList;
    private List<EmissionScopeEnum> carbonScopeList;
    private static final ClientLogger LOGGER = new ClientLogger(QueryFilter.class);

    public ReportTypeEnum reportType() {
        return this.reportType;
    }

    public DateRange dateRange() {
        return this.dateRange;
    }

    public QueryFilter withDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
        return this;
    }

    public List<String> subscriptionList() {
        return this.subscriptionList;
    }

    public QueryFilter withSubscriptionList(List<String> subscriptionList) {
        this.subscriptionList = subscriptionList;
        return this;
    }

    public List<String> resourceGroupUrlList() {
        return this.resourceGroupUrlList;
    }

    public QueryFilter withResourceGroupUrlList(List<String> resourceGroupUrlList) {
        this.resourceGroupUrlList = resourceGroupUrlList;
        return this;
    }

    public List<String> resourceTypeList() {
        return this.resourceTypeList;
    }

    public QueryFilter withResourceTypeList(List<String> resourceTypeList) {
        this.resourceTypeList = resourceTypeList;
        return this;
    }

    public List<String> locationList() {
        return this.locationList;
    }

    public QueryFilter withLocationList(List<String> locationList) {
        this.locationList = locationList;
        return this;
    }

    public List<EmissionScopeEnum> carbonScopeList() {
        return this.carbonScopeList;
    }

    public QueryFilter withCarbonScopeList(List<EmissionScopeEnum> carbonScopeList) {
        this.carbonScopeList = carbonScopeList;
        return this;
    }

    public void validate() {
        if (this.dateRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dateRange in model QueryFilter"));
        }
        this.dateRange().validate();
        if (this.subscriptionList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionList in model QueryFilter"));
        }
        if (this.carbonScopeList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property carbonScopeList in model QueryFilter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateRange", (JsonSerializable)this.dateRange);
        jsonWriter.writeArrayField("subscriptionList", this.subscriptionList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("carbonScopeList", this.carbonScopeList, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("reportType", this.reportType == null ? null : this.reportType.toString());
        jsonWriter.writeArrayField("resourceGroupUrlList", this.resourceGroupUrlList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("resourceTypeList", this.resourceTypeList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationList", this.locationList, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static QueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (QueryFilter)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                QueryFilter queryFilter;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("reportType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("OverallSummaryReport".equals(discriminatorValue)) {
                    queryFilter = OverallSummaryReportQueryFilter.fromJson(readerToUse.reset());
                    return queryFilter;
                }
                if ("MonthlySummaryReport".equals(discriminatorValue)) {
                    queryFilter = MonthlySummaryReportQueryFilter.fromJson(readerToUse.reset());
                    return queryFilter;
                }
                if ("TopItemsSummaryReport".equals(discriminatorValue)) {
                    queryFilter = TopItemsSummaryReportQueryFilter.fromJson(readerToUse.reset());
                    return queryFilter;
                }
                if ("TopItemsMonthlySummaryReport".equals(discriminatorValue)) {
                    queryFilter = TopItemsMonthlySummaryReportQueryFilter.fromJson(readerToUse.reset());
                    return queryFilter;
                }
                if ("ItemDetailsReport".equals(discriminatorValue)) {
                    queryFilter = ItemDetailsQueryFilter.fromJson(readerToUse.reset());
                    return queryFilter;
                }
                queryFilter = QueryFilter.fromJsonKnownDiscriminator(readerToUse.reset());
                return queryFilter;
            }
        });
    }

    static QueryFilter fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (QueryFilter)jsonReader.readObject(reader -> {
            QueryFilter deserializedQueryFilter = new QueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateRange".equals(fieldName)) {
                    deserializedQueryFilter.dateRange = DateRange.fromJson(reader);
                    continue;
                }
                if ("subscriptionList".equals(fieldName)) {
                    List subscriptionList;
                    deserializedQueryFilter.subscriptionList = subscriptionList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("carbonScopeList".equals(fieldName)) {
                    List carbonScopeList;
                    deserializedQueryFilter.carbonScopeList = carbonScopeList = reader.readArray(reader1 -> EmissionScopeEnum.fromString(reader1.getString()));
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    deserializedQueryFilter.reportType = ReportTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroupUrlList".equals(fieldName)) {
                    List resourceGroupUrlList;
                    deserializedQueryFilter.resourceGroupUrlList = resourceGroupUrlList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("resourceTypeList".equals(fieldName)) {
                    List resourceTypeList;
                    deserializedQueryFilter.resourceTypeList = resourceTypeList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationList".equals(fieldName)) {
                    List locationList;
                    deserializedQueryFilter.locationList = locationList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryFilter;
        });
    }
}

