/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.DateRange;
import com.azure.resourcemanager.carbonoptimization.models.EmissionScopeEnum;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.ReportTypeEnum;
import java.io.IOException;
import java.util.List;

public final class MonthlySummaryReportQueryFilter
extends QueryFilter {
    private ReportTypeEnum reportType = ReportTypeEnum.MONTHLY_SUMMARY_REPORT;
    private static final ClientLogger LOGGER = new ClientLogger(MonthlySummaryReportQueryFilter.class);

    @Override
    public ReportTypeEnum reportType() {
        return this.reportType;
    }

    @Override
    public MonthlySummaryReportQueryFilter withDateRange(DateRange dateRange) {
        super.withDateRange(dateRange);
        return this;
    }

    @Override
    public MonthlySummaryReportQueryFilter withSubscriptionList(List<String> subscriptionList) {
        super.withSubscriptionList(subscriptionList);
        return this;
    }

    @Override
    public MonthlySummaryReportQueryFilter withResourceGroupUrlList(List<String> resourceGroupUrlList) {
        super.withResourceGroupUrlList(resourceGroupUrlList);
        return this;
    }

    @Override
    public MonthlySummaryReportQueryFilter withResourceTypeList(List<String> resourceTypeList) {
        super.withResourceTypeList(resourceTypeList);
        return this;
    }

    @Override
    public MonthlySummaryReportQueryFilter withLocationList(List<String> locationList) {
        super.withLocationList(locationList);
        return this;
    }

    @Override
    public MonthlySummaryReportQueryFilter withCarbonScopeList(List<EmissionScopeEnum> carbonScopeList) {
        super.withCarbonScopeList(carbonScopeList);
        return this;
    }

    @Override
    public void validate() {
        if (this.dateRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dateRange in model MonthlySummaryReportQueryFilter"));
        }
        this.dateRange().validate();
        if (this.subscriptionList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionList in model MonthlySummaryReportQueryFilter"));
        }
        if (this.carbonScopeList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property carbonScopeList in model MonthlySummaryReportQueryFilter"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateRange", (JsonSerializable)this.dateRange());
        jsonWriter.writeArrayField("subscriptionList", this.subscriptionList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("carbonScopeList", this.carbonScopeList(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("resourceGroupUrlList", this.resourceGroupUrlList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("resourceTypeList", this.resourceTypeList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationList", this.locationList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("reportType", this.reportType == null ? null : this.reportType.toString());
        return jsonWriter.writeEndObject();
    }

    public static MonthlySummaryReportQueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (MonthlySummaryReportQueryFilter)jsonReader.readObject(reader -> {
            MonthlySummaryReportQueryFilter deserializedMonthlySummaryReportQueryFilter = new MonthlySummaryReportQueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateRange".equals(fieldName)) {
                    deserializedMonthlySummaryReportQueryFilter.withDateRange(DateRange.fromJson(reader));
                    continue;
                }
                if ("subscriptionList".equals(fieldName)) {
                    List subscriptionList = reader.readArray(reader1 -> reader1.getString());
                    deserializedMonthlySummaryReportQueryFilter.withSubscriptionList(subscriptionList);
                    continue;
                }
                if ("carbonScopeList".equals(fieldName)) {
                    List carbonScopeList = reader.readArray(reader1 -> EmissionScopeEnum.fromString(reader1.getString()));
                    deserializedMonthlySummaryReportQueryFilter.withCarbonScopeList(carbonScopeList);
                    continue;
                }
                if ("resourceGroupUrlList".equals(fieldName)) {
                    List resourceGroupUrlList = reader.readArray(reader1 -> reader1.getString());
                    deserializedMonthlySummaryReportQueryFilter.withResourceGroupUrlList(resourceGroupUrlList);
                    continue;
                }
                if ("resourceTypeList".equals(fieldName)) {
                    List resourceTypeList = reader.readArray(reader1 -> reader1.getString());
                    deserializedMonthlySummaryReportQueryFilter.withResourceTypeList(resourceTypeList);
                    continue;
                }
                if ("locationList".equals(fieldName)) {
                    List locationList = reader.readArray(reader1 -> reader1.getString());
                    deserializedMonthlySummaryReportQueryFilter.withLocationList(locationList);
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    deserializedMonthlySummaryReportQueryFilter.reportType = ReportTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonthlySummaryReportQueryFilter;
        });
    }
}

