/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;

public final class DateRange
implements JsonSerializable<DateRange> {
    private LocalDate start;
    private LocalDate end;
    private static final ClientLogger LOGGER = new ClientLogger(DateRange.class);

    public LocalDate start() {
        return this.start;
    }

    public DateRange withStart(LocalDate start) {
        this.start = start;
        return this;
    }

    public LocalDate end() {
        return this.end;
    }

    public DateRange withEnd(LocalDate end) {
        this.end = end;
        return this;
    }

    public void validate() {
        if (this.start() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property start in model DateRange"));
        }
        if (this.end() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property end in model DateRange"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", Objects.toString(this.start, null));
        jsonWriter.writeStringField("end", Objects.toString(this.end, null));
        return jsonWriter.writeEndObject();
    }

    public static DateRange fromJson(JsonReader jsonReader) throws IOException {
        return (DateRange)jsonReader.readObject(reader -> {
            DateRange deserializedDateRange = new DateRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    deserializedDateRange.start = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedDateRange.end = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDateRange;
        });
    }
}

