/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CarbonEmissionData;
import com.azure.resourcemanager.carbonoptimization.models.ResponseDataTypeEnum;
import java.io.IOException;

public final class CarbonEmissionOverallSummaryData
extends CarbonEmissionData {
    private ResponseDataTypeEnum dataType = ResponseDataTypeEnum.OVERALL_SUMMARY_DATA;

    private CarbonEmissionOverallSummaryData() {
    }

    @Override
    public ResponseDataTypeEnum dataType() {
        return this.dataType;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("latestMonthEmissions", this.latestMonthEmissions());
        jsonWriter.writeDoubleField("previousMonthEmissions", this.previousMonthEmissions());
        jsonWriter.writeNumberField("monthOverMonthEmissionsChangeRatio", (Number)this.monthOverMonthEmissionsChangeRatio());
        jsonWriter.writeNumberField("monthlyEmissionsChangeValue", (Number)this.monthlyEmissionsChangeValue());
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CarbonEmissionOverallSummaryData fromJson(JsonReader jsonReader) throws IOException {
        return (CarbonEmissionOverallSummaryData)jsonReader.readObject(reader -> {
            CarbonEmissionOverallSummaryData deserializedCarbonEmissionOverallSummaryData = new CarbonEmissionOverallSummaryData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionOverallSummaryData.withLatestMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("previousMonthEmissions".equals(fieldName)) {
                    deserializedCarbonEmissionOverallSummaryData.withPreviousMonthEmissions(reader.getDouble());
                    continue;
                }
                if ("monthOverMonthEmissionsChangeRatio".equals(fieldName)) {
                    deserializedCarbonEmissionOverallSummaryData.withMonthOverMonthEmissionsChangeRatio((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("monthlyEmissionsChangeValue".equals(fieldName)) {
                    deserializedCarbonEmissionOverallSummaryData.withMonthlyEmissionsChangeValue((Double)reader.getNullable(JsonReader::getDouble));
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedCarbonEmissionOverallSummaryData.dataType = ResponseDataTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCarbonEmissionOverallSummaryData;
        });
    }
}

