/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VmImageRepositoryCredentials
implements JsonSerializable<VmImageRepositoryCredentials> {
    private String username;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(VmImageRepositoryCredentials.class);

    public String username() {
        return this.username;
    }

    public VmImageRepositoryCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public VmImageRepositoryCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model VmImageRepositoryCredentials"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model VmImageRepositoryCredentials"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static VmImageRepositoryCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (VmImageRepositoryCredentials)jsonReader.readObject(reader -> {
            VmImageRepositoryCredentials deserializedVmImageRepositoryCredentials = new VmImageRepositoryCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedVmImageRepositoryCredentials.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedVmImageRepositoryCredentials.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVmImageRepositoryCredentials;
        });
    }
}

