/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.Identity;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstanceUpdateProperties;
import java.io.IOException;

public final class VirtualMachineInstanceUpdateRequest
implements JsonSerializable<VirtualMachineInstanceUpdateRequest> {
    private VirtualMachineInstanceUpdateProperties properties;
    private Identity identity;

    public VirtualMachineInstanceUpdateProperties properties() {
        return this.properties;
    }

    public VirtualMachineInstanceUpdateRequest withProperties(VirtualMachineInstanceUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public VirtualMachineInstanceUpdateRequest withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceUpdateRequest fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstanceUpdateRequest)jsonReader.readObject(reader -> {
            VirtualMachineInstanceUpdateRequest deserializedVirtualMachineInstanceUpdateRequest = new VirtualMachineInstanceUpdateRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineInstanceUpdateRequest.properties = VirtualMachineInstanceUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVirtualMachineInstanceUpdateRequest.identity = Identity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceUpdateRequest;
        });
    }
}

