/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.HardwareProfileUpdate;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkProfileUpdate;
import com.azure.resourcemanager.azurestackhci.vm.models.OsProfileUpdate;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageProfileUpdate;
import java.io.IOException;

public final class VirtualMachineInstanceUpdateProperties
implements JsonSerializable<VirtualMachineInstanceUpdateProperties> {
    private HardwareProfileUpdate hardwareProfile;
    private StorageProfileUpdate storageProfile;
    private NetworkProfileUpdate networkProfile;
    private OsProfileUpdate osProfile;

    public HardwareProfileUpdate hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineInstanceUpdateProperties withHardwareProfile(HardwareProfileUpdate hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public StorageProfileUpdate storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineInstanceUpdateProperties withStorageProfile(StorageProfileUpdate storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public NetworkProfileUpdate networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineInstanceUpdateProperties withNetworkProfile(NetworkProfileUpdate networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public OsProfileUpdate osProfile() {
        return this.osProfile;
    }

    public VirtualMachineInstanceUpdateProperties withOsProfile(OsProfileUpdate osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public void validate() {
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstanceUpdateProperties)jsonReader.readObject(reader -> {
            VirtualMachineInstanceUpdateProperties deserializedVirtualMachineInstanceUpdateProperties = new VirtualMachineInstanceUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceUpdateProperties.hardwareProfile = HardwareProfileUpdate.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceUpdateProperties.storageProfile = StorageProfileUpdate.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceUpdateProperties.networkProfile = NetworkProfileUpdate.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceUpdateProperties.osProfile = OsProfileUpdate.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceUpdateProperties;
        });
    }
}

