/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityTypes;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesSecurityProfileUefiSettings;
import java.io.IOException;

public final class VirtualMachineInstancePropertiesSecurityProfile
implements JsonSerializable<VirtualMachineInstancePropertiesSecurityProfile> {
    private Boolean enableTPM;
    private VirtualMachineInstancePropertiesSecurityProfileUefiSettings uefiSettings;
    private SecurityTypes securityType;

    public Boolean enableTPM() {
        return this.enableTPM;
    }

    public VirtualMachineInstancePropertiesSecurityProfile withEnableTPM(Boolean enableTPM) {
        this.enableTPM = enableTPM;
        return this;
    }

    public VirtualMachineInstancePropertiesSecurityProfileUefiSettings uefiSettings() {
        return this.uefiSettings;
    }

    public VirtualMachineInstancePropertiesSecurityProfile withUefiSettings(VirtualMachineInstancePropertiesSecurityProfileUefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }

    public SecurityTypes securityType() {
        return this.securityType;
    }

    public VirtualMachineInstancePropertiesSecurityProfile withSecurityType(SecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    public void validate() {
        if (this.uefiSettings() != null) {
            this.uefiSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableTPM", this.enableTPM);
        jsonWriter.writeJsonField("uefiSettings", (JsonSerializable)this.uefiSettings);
        jsonWriter.writeStringField("securityType", this.securityType == null ? null : this.securityType.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstancePropertiesSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstancePropertiesSecurityProfile)jsonReader.readObject(reader -> {
            VirtualMachineInstancePropertiesSecurityProfile deserializedVirtualMachineInstancePropertiesSecurityProfile = new VirtualMachineInstancePropertiesSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enableTPM".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesSecurityProfile.enableTPM = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("uefiSettings".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesSecurityProfile.uefiSettings = VirtualMachineInstancePropertiesSecurityProfileUefiSettings.fromJson(reader);
                    continue;
                }
                if ("securityType".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesSecurityProfile.securityType = SecurityTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstancePropertiesSecurityProfile;
        });
    }
}

