/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.GpuAssignmentTypeEnum;
import java.io.IOException;

public final class VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU
implements JsonSerializable<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> {
    private GpuAssignmentTypeEnum assignmentType;
    private Long partitionSizeMB;
    private String gpuName;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU.class);

    public GpuAssignmentTypeEnum assignmentType() {
        return this.assignmentType;
    }

    public VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU withAssignmentType(GpuAssignmentTypeEnum assignmentType) {
        this.assignmentType = assignmentType;
        return this;
    }

    public Long partitionSizeMB() {
        return this.partitionSizeMB;
    }

    public VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU withPartitionSizeMB(Long partitionSizeMB) {
        this.partitionSizeMB = partitionSizeMB;
        return this;
    }

    public String gpuName() {
        return this.gpuName;
    }

    public VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU withGpuName(String gpuName) {
        this.gpuName = gpuName;
        return this;
    }

    public void validate() {
        if (this.assignmentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property assignmentType in model VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assignmentType", this.assignmentType == null ? null : this.assignmentType.toString());
        jsonWriter.writeNumberField("partitionSizeMB", (Number)this.partitionSizeMB);
        jsonWriter.writeStringField("gpuName", this.gpuName);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU)jsonReader.readObject(reader -> {
            VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU deserializedVirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU = new VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assignmentType".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU.assignmentType = GpuAssignmentTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("partitionSizeMB".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU.partitionSizeMB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("gpuName".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU.gpuName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU;
        });
    }
}

