/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU;
import com.azure.resourcemanager.azurestackhci.vm.models.VmSizeEnum;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineInstancePropertiesHardwareProfile
implements JsonSerializable<VirtualMachineInstancePropertiesHardwareProfile> {
    private VmSizeEnum vmSize;
    private Integer processors;
    private Long memoryMB;
    private VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig dynamicMemoryConfig;
    private List<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> virtualMachineGPUs;

    public VmSizeEnum vmSize() {
        return this.vmSize;
    }

    public VirtualMachineInstancePropertiesHardwareProfile withVmSize(VmSizeEnum vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public Integer processors() {
        return this.processors;
    }

    public VirtualMachineInstancePropertiesHardwareProfile withProcessors(Integer processors) {
        this.processors = processors;
        return this;
    }

    public Long memoryMB() {
        return this.memoryMB;
    }

    public VirtualMachineInstancePropertiesHardwareProfile withMemoryMB(Long memoryMB) {
        this.memoryMB = memoryMB;
        return this;
    }

    public VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig dynamicMemoryConfig() {
        return this.dynamicMemoryConfig;
    }

    public VirtualMachineInstancePropertiesHardwareProfile withDynamicMemoryConfig(VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig dynamicMemoryConfig) {
        this.dynamicMemoryConfig = dynamicMemoryConfig;
        return this;
    }

    public List<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> virtualMachineGPUs() {
        return this.virtualMachineGPUs;
    }

    public VirtualMachineInstancePropertiesHardwareProfile withVirtualMachineGPUs(List<VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU> virtualMachineGPUs) {
        this.virtualMachineGPUs = virtualMachineGPUs;
        return this;
    }

    public void validate() {
        if (this.dynamicMemoryConfig() != null) {
            this.dynamicMemoryConfig().validate();
        }
        if (this.virtualMachineGPUs() != null) {
            this.virtualMachineGPUs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmSize", this.vmSize == null ? null : this.vmSize.toString());
        jsonWriter.writeNumberField("processors", (Number)this.processors);
        jsonWriter.writeNumberField("memoryMB", (Number)this.memoryMB);
        jsonWriter.writeJsonField("dynamicMemoryConfig", (JsonSerializable)this.dynamicMemoryConfig);
        jsonWriter.writeArrayField("virtualMachineGPUs", this.virtualMachineGPUs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstancePropertiesHardwareProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstancePropertiesHardwareProfile)jsonReader.readObject(reader -> {
            VirtualMachineInstancePropertiesHardwareProfile deserializedVirtualMachineInstancePropertiesHardwareProfile = new VirtualMachineInstancePropertiesHardwareProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmSize".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfile.vmSize = VmSizeEnum.fromString(reader.getString());
                    continue;
                }
                if ("processors".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfile.processors = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("memoryMB".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfile.memoryMB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("dynamicMemoryConfig".equals(fieldName)) {
                    deserializedVirtualMachineInstancePropertiesHardwareProfile.dynamicMemoryConfig = VirtualMachineInstancePropertiesHardwareProfileDynamicMemoryConfig.fromJson(reader);
                    continue;
                }
                if ("virtualMachineGPUs".equals(fieldName)) {
                    List virtualMachineGPUs;
                    deserializedVirtualMachineInstancePropertiesHardwareProfile.virtualMachineGPUs = virtualMachineGPUs = reader.readArray(reader1 -> VirtualMachineInstancePropertiesHardwareProfileVirtualMachineGPU.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstancePropertiesHardwareProfile;
        });
    }
}

