/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.GuestAgentInstallStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.HttpProxyConfiguration;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesHardwareProfile;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesNetworkProfile;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesOsProfile;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesPlacementProfile;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesSecurityProfile;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstancePropertiesStorageProfile;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstanceStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstanceView;
import java.io.IOException;

public final class VirtualMachineInstanceProperties
implements JsonSerializable<VirtualMachineInstanceProperties> {
    private VirtualMachineInstancePropertiesHardwareProfile hardwareProfile;
    private VirtualMachineInstancePropertiesPlacementProfile placementProfile;
    private VirtualMachineInstancePropertiesNetworkProfile networkProfile;
    private VirtualMachineInstancePropertiesOsProfile osProfile;
    private VirtualMachineInstancePropertiesSecurityProfile securityProfile;
    private VirtualMachineInstancePropertiesStorageProfile storageProfile;
    private HttpProxyConfiguration httpProxyConfig;
    private Boolean createFromLocal;
    private ProvisioningStateEnum provisioningState;
    private VirtualMachineInstanceView instanceView;
    private VirtualMachineInstanceStatus status;
    private GuestAgentInstallStatus guestAgentInstallStatus;
    private String vmId;
    private String resourceUid;
    private String hyperVVmId;
    private String hostNodeName;
    private String hostNodeIpAddress;

    public VirtualMachineInstancePropertiesHardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineInstanceProperties withHardwareProfile(VirtualMachineInstancePropertiesHardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public VirtualMachineInstancePropertiesPlacementProfile placementProfile() {
        return this.placementProfile;
    }

    public VirtualMachineInstanceProperties withPlacementProfile(VirtualMachineInstancePropertiesPlacementProfile placementProfile) {
        this.placementProfile = placementProfile;
        return this;
    }

    public VirtualMachineInstancePropertiesNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineInstanceProperties withNetworkProfile(VirtualMachineInstancePropertiesNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public VirtualMachineInstancePropertiesOsProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineInstanceProperties withOsProfile(VirtualMachineInstancePropertiesOsProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public VirtualMachineInstancePropertiesSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineInstanceProperties withSecurityProfile(VirtualMachineInstancePropertiesSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public VirtualMachineInstancePropertiesStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineInstanceProperties withStorageProfile(VirtualMachineInstancePropertiesStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public HttpProxyConfiguration httpProxyConfig() {
        return this.httpProxyConfig;
    }

    public VirtualMachineInstanceProperties withHttpProxyConfig(HttpProxyConfiguration httpProxyConfig) {
        this.httpProxyConfig = httpProxyConfig;
        return this;
    }

    public Boolean createFromLocal() {
        return this.createFromLocal;
    }

    public VirtualMachineInstanceProperties withCreateFromLocal(Boolean createFromLocal) {
        this.createFromLocal = createFromLocal;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineInstanceView instanceView() {
        return this.instanceView;
    }

    public VirtualMachineInstanceStatus status() {
        return this.status;
    }

    public GuestAgentInstallStatus guestAgentInstallStatus() {
        return this.guestAgentInstallStatus;
    }

    public VirtualMachineInstanceProperties withGuestAgentInstallStatus(GuestAgentInstallStatus guestAgentInstallStatus) {
        this.guestAgentInstallStatus = guestAgentInstallStatus;
        return this;
    }

    public String vmId() {
        return this.vmId;
    }

    public String resourceUid() {
        return this.resourceUid;
    }

    public VirtualMachineInstanceProperties withResourceUid(String resourceUid) {
        this.resourceUid = resourceUid;
        return this;
    }

    public String hyperVVmId() {
        return this.hyperVVmId;
    }

    public String hostNodeName() {
        return this.hostNodeName;
    }

    public String hostNodeIpAddress() {
        return this.hostNodeIpAddress;
    }

    public void validate() {
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.placementProfile() != null) {
            this.placementProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.httpProxyConfig() != null) {
            this.httpProxyConfig().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.guestAgentInstallStatus() != null) {
            this.guestAgentInstallStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeJsonField("placementProfile", (JsonSerializable)this.placementProfile);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("httpProxyConfig", (JsonSerializable)this.httpProxyConfig);
        jsonWriter.writeBooleanField("createFromLocal", this.createFromLocal);
        jsonWriter.writeJsonField("guestAgentInstallStatus", (JsonSerializable)this.guestAgentInstallStatus);
        jsonWriter.writeStringField("resourceUid", this.resourceUid);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInstanceProperties)jsonReader.readObject(reader -> {
            VirtualMachineInstanceProperties deserializedVirtualMachineInstanceProperties = new VirtualMachineInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.hardwareProfile = VirtualMachineInstancePropertiesHardwareProfile.fromJson(reader);
                    continue;
                }
                if ("placementProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.placementProfile = VirtualMachineInstancePropertiesPlacementProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.networkProfile = VirtualMachineInstancePropertiesNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.osProfile = VirtualMachineInstancePropertiesOsProfile.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.securityProfile = VirtualMachineInstancePropertiesSecurityProfile.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.storageProfile = VirtualMachineInstancePropertiesStorageProfile.fromJson(reader);
                    continue;
                }
                if ("httpProxyConfig".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.httpProxyConfig = HttpProxyConfiguration.fromJson(reader);
                    continue;
                }
                if ("createFromLocal".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.createFromLocal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.instanceView = VirtualMachineInstanceView.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.status = VirtualMachineInstanceStatus.fromJson(reader);
                    continue;
                }
                if ("guestAgentInstallStatus".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.guestAgentInstallStatus = GuestAgentInstallStatus.fromJson(reader);
                    continue;
                }
                if ("vmId".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.vmId = reader.getString();
                    continue;
                }
                if ("resourceUid".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.resourceUid = reader.getString();
                    continue;
                }
                if ("hyperVVmId".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.hyperVVmId = reader.getString();
                    continue;
                }
                if ("hostNodeName".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.hostNodeName = reader.getString();
                    continue;
                }
                if ("hostNodeIpAddress".equals(fieldName)) {
                    deserializedVirtualMachineInstanceProperties.hostNodeIpAddress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInstanceProperties;
        });
    }
}

