/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.DiskFileFormat;
import com.azure.resourcemanager.azurestackhci.vm.models.HyperVGeneration;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskStatus;
import java.io.IOException;

public final class VirtualHardDiskProperties
implements JsonSerializable<VirtualHardDiskProperties> {
    private Integer blockSizeBytes;
    private Long diskSizeGB;
    private Boolean dynamic;
    private Integer logicalSectorBytes;
    private Integer physicalSectorBytes;
    private String downloadUrl;
    private HyperVGeneration hyperVGeneration;
    private DiskFileFormat diskFileFormat;
    private Boolean createFromLocal;
    private ProvisioningStateEnum provisioningState;
    private String containerId;
    private VirtualHardDiskStatus status;
    private Long maxShares;

    public Integer blockSizeBytes() {
        return this.blockSizeBytes;
    }

    public VirtualHardDiskProperties withBlockSizeBytes(Integer blockSizeBytes) {
        this.blockSizeBytes = blockSizeBytes;
        return this;
    }

    public Long diskSizeGB() {
        return this.diskSizeGB;
    }

    public VirtualHardDiskProperties withDiskSizeGB(Long diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Boolean dynamic() {
        return this.dynamic;
    }

    public VirtualHardDiskProperties withDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public Integer logicalSectorBytes() {
        return this.logicalSectorBytes;
    }

    public VirtualHardDiskProperties withLogicalSectorBytes(Integer logicalSectorBytes) {
        this.logicalSectorBytes = logicalSectorBytes;
        return this;
    }

    public Integer physicalSectorBytes() {
        return this.physicalSectorBytes;
    }

    public VirtualHardDiskProperties withPhysicalSectorBytes(Integer physicalSectorBytes) {
        this.physicalSectorBytes = physicalSectorBytes;
        return this;
    }

    public String downloadUrl() {
        return this.downloadUrl;
    }

    public VirtualHardDiskProperties withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualHardDiskProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public DiskFileFormat diskFileFormat() {
        return this.diskFileFormat;
    }

    public VirtualHardDiskProperties withDiskFileFormat(DiskFileFormat diskFileFormat) {
        this.diskFileFormat = diskFileFormat;
        return this;
    }

    public Boolean createFromLocal() {
        return this.createFromLocal;
    }

    public VirtualHardDiskProperties withCreateFromLocal(Boolean createFromLocal) {
        this.createFromLocal = createFromLocal;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public String containerId() {
        return this.containerId;
    }

    public VirtualHardDiskProperties withContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public VirtualHardDiskStatus status() {
        return this.status;
    }

    public Long maxShares() {
        return this.maxShares;
    }

    public VirtualHardDiskProperties withMaxShares(Long maxShares) {
        this.maxShares = maxShares;
        return this;
    }

    public void validate() {
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("blockSizeBytes", (Number)this.blockSizeBytes);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeBooleanField("dynamic", this.dynamic);
        jsonWriter.writeNumberField("logicalSectorBytes", (Number)this.logicalSectorBytes);
        jsonWriter.writeNumberField("physicalSectorBytes", (Number)this.physicalSectorBytes);
        jsonWriter.writeStringField("downloadUrl", this.downloadUrl);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeStringField("diskFileFormat", this.diskFileFormat == null ? null : this.diskFileFormat.toString());
        jsonWriter.writeBooleanField("createFromLocal", this.createFromLocal);
        jsonWriter.writeStringField("containerId", this.containerId);
        jsonWriter.writeNumberField("maxShares", (Number)this.maxShares);
        return jsonWriter.writeEndObject();
    }

    public static VirtualHardDiskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualHardDiskProperties)jsonReader.readObject(reader -> {
            VirtualHardDiskProperties deserializedVirtualHardDiskProperties = new VirtualHardDiskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blockSizeBytes".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.blockSizeBytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.diskSizeGB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("dynamic".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.dynamic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("logicalSectorBytes".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.logicalSectorBytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("physicalSectorBytes".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.physicalSectorBytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("downloadUrl".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.downloadUrl = reader.getString();
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("diskFileFormat".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.diskFileFormat = DiskFileFormat.fromString(reader.getString());
                    continue;
                }
                if ("createFromLocal".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.createFromLocal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("containerId".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.containerId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.status = VirtualHardDiskStatus.fromJson(reader);
                    continue;
                }
                if ("maxShares".equals(fieldName)) {
                    deserializedVirtualHardDiskProperties.maxShares = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualHardDiskProperties;
        });
    }
}

