/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.SubnetProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.IPPool;
import com.azure.resourcemanager.azurestackhci.vm.models.IpAllocationMethodEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.RouteTable;
import com.azure.resourcemanager.azurestackhci.vm.models.SubnetIpConfigurationReference;
import java.io.IOException;
import java.util.List;

public final class Subnet
implements JsonSerializable<Subnet> {
    private SubnetProperties innerProperties;
    private String name;

    private SubnetProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public Subnet withName(String name) {
        this.name = name;
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public Subnet withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public List<String> addressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefixes();
    }

    public Subnet withAddressPrefixes(List<String> addressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withAddressPrefixes(addressPrefixes);
        return this;
    }

    public IpAllocationMethodEnum ipAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAllocationMethod();
    }

    public Subnet withIpAllocationMethod(IpAllocationMethodEnum ipAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withIpAllocationMethod(ipAllocationMethod);
        return this;
    }

    public List<SubnetIpConfigurationReference> ipConfigurationReferences() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurationReferences();
    }

    public Subnet withIpConfigurationReferences(List<SubnetIpConfigurationReference> ipConfigurationReferences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withIpConfigurationReferences(ipConfigurationReferences);
        return this;
    }

    public NetworkSecurityGroupArmReference networkSecurityGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityGroup();
    }

    public Subnet withNetworkSecurityGroup(NetworkSecurityGroupArmReference networkSecurityGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withNetworkSecurityGroup(networkSecurityGroup);
        return this;
    }

    public RouteTable routeTable() {
        return this.innerProperties() == null ? null : this.innerProperties().routeTable();
    }

    public Subnet withRouteTable(RouteTable routeTable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withRouteTable(routeTable);
        return this;
    }

    public List<IPPool> ipPools() {
        return this.innerProperties() == null ? null : this.innerProperties().ipPools();
    }

    public Subnet withIpPools(List<IPPool> ipPools) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withIpPools(ipPools);
        return this;
    }

    public Integer vlan() {
        return this.innerProperties() == null ? null : this.innerProperties().vlan();
    }

    public Subnet withVlan(Integer vlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetProperties();
        }
        this.innerProperties().withVlan(vlan);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static Subnet fromJson(JsonReader jsonReader) throws IOException {
        return (Subnet)jsonReader.readObject(reader -> {
            Subnet deserializedSubnet = new Subnet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSubnet.innerProperties = SubnetProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSubnet.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubnet;
        });
    }
}

