/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.StorageContainerStatus;
import java.io.IOException;

public final class StorageContainerProperties
implements JsonSerializable<StorageContainerProperties> {
    private String path;
    private ProvisioningStateEnum provisioningState;
    private StorageContainerStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(StorageContainerProperties.class);

    public String path() {
        return this.path;
    }

    public StorageContainerProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public StorageContainerStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model StorageContainerProperties"));
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    public static StorageContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageContainerProperties)jsonReader.readObject(reader -> {
            StorageContainerProperties deserializedStorageContainerProperties = new StorageContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedStorageContainerProperties.path = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageContainerProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedStorageContainerProperties.status = StorageContainerStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageContainerProperties;
        });
    }
}

