/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRuleAccess;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRuleDirection;
import com.azure.resourcemanager.azurestackhci.vm.models.SecurityRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class SecurityRuleProperties
implements JsonSerializable<SecurityRuleProperties> {
    private String description;
    private SecurityRuleProtocol protocol;
    private List<String> sourceAddressPrefixes;
    private List<String> destinationAddressPrefixes;
    private List<String> sourcePortRanges;
    private List<String> destinationPortRanges;
    private SecurityRuleAccess access;
    private int priority;
    private SecurityRuleDirection direction;
    private ProvisioningStateEnum provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityRuleProperties.class);

    public String description() {
        return this.description;
    }

    public SecurityRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityRuleProtocol protocol() {
        return this.protocol;
    }

    public SecurityRuleProperties withProtocol(SecurityRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<String> sourceAddressPrefixes() {
        return this.sourceAddressPrefixes;
    }

    public SecurityRuleProperties withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        this.sourceAddressPrefixes = sourceAddressPrefixes;
        return this;
    }

    public List<String> destinationAddressPrefixes() {
        return this.destinationAddressPrefixes;
    }

    public SecurityRuleProperties withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        this.destinationAddressPrefixes = destinationAddressPrefixes;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public SecurityRuleProperties withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public SecurityRuleProperties withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public SecurityRuleAccess access() {
        return this.access;
    }

    public SecurityRuleProperties withAccess(SecurityRuleAccess access) {
        this.access = access;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public SecurityRuleProperties withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public SecurityRuleDirection direction() {
        return this.direction;
    }

    public SecurityRuleProperties withDirection(SecurityRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model SecurityRuleProperties"));
        }
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model SecurityRuleProperties"));
        }
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model SecurityRuleProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("sourceAddressPrefixes", this.sourceAddressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationAddressPrefixes", this.destinationAddressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SecurityRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityRuleProperties)jsonReader.readObject(reader -> {
            SecurityRuleProperties deserializedSecurityRuleProperties = new SecurityRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedSecurityRuleProperties.protocol = SecurityRuleProtocol.fromString(reader.getString());
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedSecurityRuleProperties.access = SecurityRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedSecurityRuleProperties.priority = reader.getInt();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedSecurityRuleProperties.direction = SecurityRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSecurityRuleProperties.description = reader.getString();
                    continue;
                }
                if ("sourceAddressPrefixes".equals(fieldName)) {
                    List sourceAddressPrefixes;
                    deserializedSecurityRuleProperties.sourceAddressPrefixes = sourceAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationAddressPrefixes".equals(fieldName)) {
                    List destinationAddressPrefixes;
                    deserializedSecurityRuleProperties.destinationAddressPrefixes = destinationAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List sourcePortRanges;
                    deserializedSecurityRuleProperties.sourcePortRanges = sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List destinationPortRanges;
                    deserializedSecurityRuleProperties.destinationPortRanges = destinationPortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityRuleProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityRuleProperties;
        });
    }
}

