/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.RouteTableProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.Route;
import java.io.IOException;
import java.util.List;

public final class RouteTable
implements JsonSerializable<RouteTable> {
    private String etag;
    private String name;
    private String type;
    private RouteTableProperties innerProperties;

    public String etag() {
        return this.etag;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private RouteTableProperties innerProperties() {
        return this.innerProperties;
    }

    public List<Route> routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    public RouteTable withRoutes(List<Route> routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteTableProperties();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RouteTable fromJson(JsonReader jsonReader) throws IOException {
        return (RouteTable)jsonReader.readObject(reader -> {
            RouteTable deserializedRouteTable = new RouteTable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("etag".equals(fieldName)) {
                    deserializedRouteTable.etag = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRouteTable.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRouteTable.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRouteTable.innerProperties = RouteTableProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteTable;
        });
    }
}

