/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.RouteProperties;
import java.io.IOException;

public final class Route
implements JsonSerializable<Route> {
    private RouteProperties innerProperties;
    private String name;

    private RouteProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public Route withName(String name) {
        this.name = name;
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public Route withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteProperties();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public String nextHopIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().nextHopIpAddress();
    }

    public Route withNextHopIpAddress(String nextHopIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteProperties();
        }
        this.innerProperties().withNextHopIpAddress(nextHopIpAddress);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static Route fromJson(JsonReader jsonReader) throws IOException {
        return (Route)jsonReader.readObject(reader -> {
            Route deserializedRoute = new Route();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedRoute.innerProperties = RouteProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoute.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoute;
        });
    }
}

