/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfaceArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityGroupProperties
implements JsonSerializable<NetworkSecurityGroupProperties> {
    private List<NetworkInterfaceArmReference> networkInterfaces;
    private List<LogicalNetworkArmReference> subnets;
    private ProvisioningStateEnum provisioningState;
    private NetworkSecurityGroupStatus status;

    public List<NetworkInterfaceArmReference> networkInterfaces() {
        return this.networkInterfaces;
    }

    public List<LogicalNetworkArmReference> subnets() {
        return this.subnets;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public NetworkSecurityGroupStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityGroupProperties)jsonReader.readObject(reader -> {
            NetworkSecurityGroupProperties deserializedNetworkSecurityGroupProperties = new NetworkSecurityGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkInterfaces".equals(fieldName)) {
                    List networkInterfaces;
                    deserializedNetworkSecurityGroupProperties.networkInterfaces = networkInterfaces = reader.readArray(reader1 -> NetworkInterfaceArmReference.fromJson(reader1));
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List subnets;
                    deserializedNetworkSecurityGroupProperties.subnets = subnets = reader.readArray(reader1 -> LogicalNetworkArmReference.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityGroupProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedNetworkSecurityGroupProperties.status = NetworkSecurityGroupStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupProperties;
        });
    }
}

