/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfacesUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class NetworkInterfacesUpdateRequest
implements JsonSerializable<NetworkInterfacesUpdateRequest> {
    private Map<String, String> tags;
    private NetworkInterfacesUpdateProperties properties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public NetworkInterfacesUpdateRequest withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public NetworkInterfacesUpdateProperties properties() {
        return this.properties;
    }

    public NetworkInterfacesUpdateRequest withProperties(NetworkInterfacesUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfacesUpdateRequest fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfacesUpdateRequest)jsonReader.readObject(reader -> {
            NetworkInterfacesUpdateRequest deserializedNetworkInterfacesUpdateRequest = new NetworkInterfacesUpdateRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedNetworkInterfacesUpdateRequest.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkInterfacesUpdateRequest.properties = NetworkInterfacesUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfacesUpdateRequest;
        });
    }
}

