/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.InterfaceDNSSettings;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupArmReference;
import java.io.IOException;

public final class NetworkInterfacesUpdateProperties
implements JsonSerializable<NetworkInterfacesUpdateProperties> {
    private NetworkSecurityGroupArmReference networkSecurityGroup;
    private InterfaceDNSSettings dnsSettings;

    public NetworkSecurityGroupArmReference networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public NetworkInterfacesUpdateProperties withNetworkSecurityGroup(NetworkSecurityGroupArmReference networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public InterfaceDNSSettings dnsSettings() {
        return this.dnsSettings;
    }

    public NetworkInterfacesUpdateProperties withDnsSettings(InterfaceDNSSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public void validate() {
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfacesUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfacesUpdateProperties)jsonReader.readObject(reader -> {
            NetworkInterfacesUpdateProperties deserializedNetworkInterfacesUpdateProperties = new NetworkInterfacesUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedNetworkInterfacesUpdateProperties.networkSecurityGroup = NetworkSecurityGroupArmReference.fromJson(reader);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedNetworkInterfacesUpdateProperties.dnsSettings = InterfaceDNSSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfacesUpdateProperties;
        });
    }
}

