/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfaceStatusProvisioningStatus;
import java.io.IOException;

public final class NetworkInterfaceStatus
implements JsonSerializable<NetworkInterfaceStatus> {
    private String errorCode;
    private String errorMessage;
    private NetworkInterfaceStatusProvisioningStatus provisioningStatus;

    private NetworkInterfaceStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public NetworkInterfaceStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceStatus fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceStatus)jsonReader.readObject(reader -> {
            NetworkInterfaceStatus deserializedNetworkInterfaceStatus = new NetworkInterfaceStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedNetworkInterfaceStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedNetworkInterfaceStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedNetworkInterfaceStatus.provisioningStatus = NetworkInterfaceStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceStatus;
        });
    }
}

