/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.IPConfiguration;
import com.azure.resourcemanager.azurestackhci.vm.models.InterfaceDNSSettings;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkInterfaceStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.NetworkSecurityGroupArmReference;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import java.io.IOException;
import java.util.List;

public final class NetworkInterfaceProperties
implements JsonSerializable<NetworkInterfaceProperties> {
    private List<IPConfiguration> ipConfigurations;
    private String macAddress;
    private InterfaceDNSSettings dnsSettings;
    private Boolean createFromLocal;
    private ProvisioningStateEnum provisioningState;
    private NetworkInterfaceStatus status;
    private NetworkSecurityGroupArmReference networkSecurityGroup;

    public List<IPConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public NetworkInterfaceProperties withIpConfigurations(List<IPConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public NetworkInterfaceProperties withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    public InterfaceDNSSettings dnsSettings() {
        return this.dnsSettings;
    }

    public NetworkInterfaceProperties withDnsSettings(InterfaceDNSSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public Boolean createFromLocal() {
        return this.createFromLocal;
    }

    public NetworkInterfaceProperties withCreateFromLocal(Boolean createFromLocal) {
        this.createFromLocal = createFromLocal;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public NetworkInterfaceStatus status() {
        return this.status;
    }

    public NetworkSecurityGroupArmReference networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public NetworkInterfaceProperties withNetworkSecurityGroup(NetworkSecurityGroupArmReference networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public void validate() {
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("macAddress", this.macAddress);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeBooleanField("createFromLocal", this.createFromLocal);
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceProperties)jsonReader.readObject(reader -> {
            NetworkInterfaceProperties deserializedNetworkInterfaceProperties = new NetworkInterfaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedNetworkInterfaceProperties.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> IPConfiguration.fromJson(reader1));
                    continue;
                }
                if ("macAddress".equals(fieldName)) {
                    deserializedNetworkInterfaceProperties.macAddress = reader.getString();
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedNetworkInterfaceProperties.dnsSettings = InterfaceDNSSettings.fromJson(reader);
                    continue;
                }
                if ("createFromLocal".equals(fieldName)) {
                    deserializedNetworkInterfaceProperties.createFromLocal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkInterfaceProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedNetworkInterfaceProperties.status = NetworkInterfaceStatus.fromJson(reader);
                    continue;
                }
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedNetworkInterfaceProperties.networkSecurityGroup = NetworkSecurityGroupArmReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceProperties;
        });
    }
}

