/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkStatusProvisioningStatus;
import java.io.IOException;

public final class LogicalNetworkStatus
implements JsonSerializable<LogicalNetworkStatus> {
    private String errorCode;
    private String errorMessage;
    private LogicalNetworkStatusProvisioningStatus provisioningStatus;

    private LogicalNetworkStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public LogicalNetworkStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        return jsonWriter.writeEndObject();
    }

    public static LogicalNetworkStatus fromJson(JsonReader jsonReader) throws IOException {
        return (LogicalNetworkStatus)jsonReader.readObject(reader -> {
            LogicalNetworkStatus deserializedLogicalNetworkStatus = new LogicalNetworkStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedLogicalNetworkStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedLogicalNetworkStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedLogicalNetworkStatus.provisioningStatus = LogicalNetworkStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogicalNetworkStatus;
        });
    }
}

