/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkPropertiesDhcpOptions;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.LogicalNetworkTypeEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.Subnet;
import java.io.IOException;
import java.util.List;

public final class LogicalNetworkProperties
implements JsonSerializable<LogicalNetworkProperties> {
    private LogicalNetworkPropertiesDhcpOptions dhcpOptions;
    private List<Subnet> subnets;
    private ProvisioningStateEnum provisioningState;
    private String vmSwitchName;
    private LogicalNetworkStatus status;
    private LogicalNetworkTypeEnum networkType;

    public LogicalNetworkPropertiesDhcpOptions dhcpOptions() {
        return this.dhcpOptions;
    }

    public LogicalNetworkProperties withDhcpOptions(LogicalNetworkPropertiesDhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public LogicalNetworkProperties withSubnets(List<Subnet> subnets) {
        this.subnets = subnets;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public String vmSwitchName() {
        return this.vmSwitchName;
    }

    public LogicalNetworkProperties withVmSwitchName(String vmSwitchName) {
        this.vmSwitchName = vmSwitchName;
        return this;
    }

    public LogicalNetworkStatus status() {
        return this.status;
    }

    public LogicalNetworkTypeEnum networkType() {
        return this.networkType;
    }

    public void validate() {
        if (this.dhcpOptions() != null) {
            this.dhcpOptions().validate();
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dhcpOptions", (JsonSerializable)this.dhcpOptions);
        jsonWriter.writeArrayField("subnets", this.subnets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("vmSwitchName", this.vmSwitchName);
        return jsonWriter.writeEndObject();
    }

    public static LogicalNetworkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LogicalNetworkProperties)jsonReader.readObject(reader -> {
            LogicalNetworkProperties deserializedLogicalNetworkProperties = new LogicalNetworkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dhcpOptions".equals(fieldName)) {
                    deserializedLogicalNetworkProperties.dhcpOptions = LogicalNetworkPropertiesDhcpOptions.fromJson(reader);
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List subnets;
                    deserializedLogicalNetworkProperties.subnets = subnets = reader.readArray(reader1 -> Subnet.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedLogicalNetworkProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("vmSwitchName".equals(fieldName)) {
                    deserializedLogicalNetworkProperties.vmSwitchName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLogicalNetworkProperties.status = LogicalNetworkStatus.fromJson(reader);
                    continue;
                }
                if ("networkType".equals(fieldName)) {
                    deserializedLogicalNetworkProperties.networkType = LogicalNetworkTypeEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogicalNetworkProperties;
        });
    }
}

