/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.IdentityType;
import java.io.IOException;

public final class Identity
implements JsonSerializable<Identity> {
    private String principalId;
    private String tenantId;
    private IdentityType type;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public IdentityType type() {
        return this.type;
    }

    public Identity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Identity fromJson(JsonReader jsonReader) throws IOException {
        return (Identity)jsonReader.readObject(reader -> {
            Identity deserializedIdentity = new Identity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentity.type = IdentityType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentity;
        });
    }
}

