/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.IPPoolInfo;
import com.azure.resourcemanager.azurestackhci.vm.models.IPPoolTypeEnum;
import java.io.IOException;

public final class IPPool
implements JsonSerializable<IPPool> {
    private String name;
    private IPPoolTypeEnum ipPoolType;
    private String start;
    private String end;
    private IPPoolInfo info;

    public String name() {
        return this.name;
    }

    public IPPool withName(String name) {
        this.name = name;
        return this;
    }

    public IPPoolTypeEnum ipPoolType() {
        return this.ipPoolType;
    }

    public IPPool withIpPoolType(IPPoolTypeEnum ipPoolType) {
        this.ipPoolType = ipPoolType;
        return this;
    }

    public String start() {
        return this.start;
    }

    public IPPool withStart(String start) {
        this.start = start;
        return this;
    }

    public String end() {
        return this.end;
    }

    public IPPool withEnd(String end) {
        this.end = end;
        return this;
    }

    public IPPoolInfo info() {
        return this.info;
    }

    public IPPool withInfo(IPPoolInfo info) {
        this.info = info;
        return this;
    }

    public void validate() {
        if (this.info() != null) {
            this.info().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("ipPoolType", this.ipPoolType == null ? null : this.ipPoolType.toString());
        jsonWriter.writeStringField("start", this.start);
        jsonWriter.writeStringField("end", this.end);
        jsonWriter.writeJsonField("info", (JsonSerializable)this.info);
        return jsonWriter.writeEndObject();
    }

    public static IPPool fromJson(JsonReader jsonReader) throws IOException {
        return (IPPool)jsonReader.readObject(reader -> {
            IPPool deserializedIPPool = new IPPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIPPool.name = reader.getString();
                    continue;
                }
                if ("ipPoolType".equals(fieldName)) {
                    deserializedIPPool.ipPoolType = IPPoolTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("start".equals(fieldName)) {
                    deserializedIPPool.start = reader.getString();
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedIPPool.end = reader.getString();
                    continue;
                }
                if ("info".equals(fieldName)) {
                    deserializedIPPool.info = IPPoolInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIPPool;
        });
    }
}

