/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.IPConfigurationProperties;
import java.io.IOException;

public final class IPConfiguration
implements JsonSerializable<IPConfiguration> {
    private String name;
    private IPConfigurationProperties properties;

    public String name() {
        return this.name;
    }

    public IPConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public IPConfigurationProperties properties() {
        return this.properties;
    }

    public IPConfiguration withProperties(IPConfigurationProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IPConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (IPConfiguration)jsonReader.readObject(reader -> {
            IPConfiguration deserializedIPConfiguration = new IPConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIPConfiguration.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIPConfiguration.properties = IPConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIPConfiguration;
        });
    }
}

