/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.Identity;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import java.io.IOException;

public final class HybridIdentityMetadataProperties
implements JsonSerializable<HybridIdentityMetadataProperties> {
    private String resourceUid;
    private String publicKey;
    private Identity identity;
    private ProvisioningStateEnum provisioningState;

    private HybridIdentityMetadataProperties() {
    }

    public String resourceUid() {
        return this.resourceUid;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public Identity identity() {
        return this.identity;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceUid", this.resourceUid);
        jsonWriter.writeStringField("publicKey", this.publicKey);
        return jsonWriter.writeEndObject();
    }

    public static HybridIdentityMetadataProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HybridIdentityMetadataProperties)jsonReader.readObject(reader -> {
            HybridIdentityMetadataProperties deserializedHybridIdentityMetadataProperties = new HybridIdentityMetadataProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceUid".equals(fieldName)) {
                    deserializedHybridIdentityMetadataProperties.resourceUid = reader.getString();
                    continue;
                }
                if ("publicKey".equals(fieldName)) {
                    deserializedHybridIdentityMetadataProperties.publicKey = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedHybridIdentityMetadataProperties.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedHybridIdentityMetadataProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridIdentityMetadataProperties;
        });
    }
}

