/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageStatusDownloadStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageStatusProvisioningStatus;
import java.io.IOException;

public final class GalleryImageStatus
implements JsonSerializable<GalleryImageStatus> {
    private String errorCode;
    private String errorMessage;
    private GalleryImageStatusProvisioningStatus provisioningStatus;
    private GalleryImageStatusDownloadStatus downloadStatus;
    private Long progressPercentage;

    private GalleryImageStatus() {
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public GalleryImageStatusProvisioningStatus provisioningStatus() {
        return this.provisioningStatus;
    }

    public GalleryImageStatusDownloadStatus downloadStatus() {
        return this.downloadStatus;
    }

    public Long progressPercentage() {
        return this.progressPercentage;
    }

    public void validate() {
        if (this.provisioningStatus() != null) {
            this.provisioningStatus().validate();
        }
        if (this.downloadStatus() != null) {
            this.downloadStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeJsonField("provisioningStatus", (JsonSerializable)this.provisioningStatus);
        jsonWriter.writeJsonField("downloadStatus", (JsonSerializable)this.downloadStatus);
        jsonWriter.writeNumberField("progressPercentage", (Number)this.progressPercentage);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageStatus fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageStatus)jsonReader.readObject(reader -> {
            GalleryImageStatus deserializedGalleryImageStatus = new GalleryImageStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errorCode".equals(fieldName)) {
                    deserializedGalleryImageStatus.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedGalleryImageStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedGalleryImageStatus.provisioningStatus = GalleryImageStatusProvisioningStatus.fromJson(reader);
                    continue;
                }
                if ("downloadStatus".equals(fieldName)) {
                    deserializedGalleryImageStatus.downloadStatus = GalleryImageStatusDownloadStatus.fromJson(reader);
                    continue;
                }
                if ("progressPercentage".equals(fieldName)) {
                    deserializedGalleryImageStatus.progressPercentage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageStatus;
        });
    }
}

