/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.models.CloudInitDataSource;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageIdentifier;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageStatus;
import com.azure.resourcemanager.azurestackhci.vm.models.GalleryImageVersion;
import com.azure.resourcemanager.azurestackhci.vm.models.HyperVGeneration;
import com.azure.resourcemanager.azurestackhci.vm.models.OperatingSystemTypes;
import com.azure.resourcemanager.azurestackhci.vm.models.ProvisioningStateEnum;
import com.azure.resourcemanager.azurestackhci.vm.models.VmImageRepositoryCredentials;
import java.io.IOException;

public final class GalleryImageProperties
implements JsonSerializable<GalleryImageProperties> {
    private String containerId;
    private String imagePath;
    private OperatingSystemTypes osType;
    private CloudInitDataSource cloudInitDataSource;
    private HyperVGeneration hyperVGeneration;
    private VmImageRepositoryCredentials vmImageRepositoryCredentials;
    private GalleryImageIdentifier identifier;
    private GalleryImageVersion version;
    private ProvisioningStateEnum provisioningState;
    private GalleryImageStatus status;
    private String sourceVirtualMachineId;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageProperties.class);

    public String containerId() {
        return this.containerId;
    }

    public GalleryImageProperties withContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public String imagePath() {
        return this.imagePath;
    }

    public GalleryImageProperties withImagePath(String imagePath) {
        this.imagePath = imagePath;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public GalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public CloudInitDataSource cloudInitDataSource() {
        return this.cloudInitDataSource;
    }

    public GalleryImageProperties withCloudInitDataSource(CloudInitDataSource cloudInitDataSource) {
        this.cloudInitDataSource = cloudInitDataSource;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public GalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public VmImageRepositoryCredentials vmImageRepositoryCredentials() {
        return this.vmImageRepositoryCredentials;
    }

    public GalleryImageProperties withVmImageRepositoryCredentials(VmImageRepositoryCredentials vmImageRepositoryCredentials) {
        this.vmImageRepositoryCredentials = vmImageRepositoryCredentials;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public GalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public GalleryImageVersion version() {
        return this.version;
    }

    public GalleryImageProperties withVersion(GalleryImageVersion version) {
        this.version = version;
        return this;
    }

    public ProvisioningStateEnum provisioningState() {
        return this.provisioningState;
    }

    public GalleryImageStatus status() {
        return this.status;
    }

    public String sourceVirtualMachineId() {
        return this.sourceVirtualMachineId;
    }

    public GalleryImageProperties withSourceVirtualMachineId(String sourceVirtualMachineId) {
        this.sourceVirtualMachineId = sourceVirtualMachineId;
        return this;
    }

    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model GalleryImageProperties"));
        }
        if (this.vmImageRepositoryCredentials() != null) {
            this.vmImageRepositoryCredentials().validate();
        }
        if (this.identifier() != null) {
            this.identifier().validate();
        }
        if (this.version() != null) {
            this.version().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("containerId", this.containerId);
        jsonWriter.writeStringField("imagePath", this.imagePath);
        jsonWriter.writeStringField("cloudInitDataSource", this.cloudInitDataSource == null ? null : this.cloudInitDataSource.toString());
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("vmImageRepositoryCredentials", (JsonSerializable)this.vmImageRepositoryCredentials);
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.identifier);
        jsonWriter.writeJsonField("version", (JsonSerializable)this.version);
        jsonWriter.writeStringField("sourceVirtualMachineId", this.sourceVirtualMachineId);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageProperties)jsonReader.readObject(reader -> {
            GalleryImageProperties deserializedGalleryImageProperties = new GalleryImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedGalleryImageProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("containerId".equals(fieldName)) {
                    deserializedGalleryImageProperties.containerId = reader.getString();
                    continue;
                }
                if ("imagePath".equals(fieldName)) {
                    deserializedGalleryImageProperties.imagePath = reader.getString();
                    continue;
                }
                if ("cloudInitDataSource".equals(fieldName)) {
                    deserializedGalleryImageProperties.cloudInitDataSource = CloudInitDataSource.fromString(reader.getString());
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedGalleryImageProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("vmImageRepositoryCredentials".equals(fieldName)) {
                    deserializedGalleryImageProperties.vmImageRepositoryCredentials = VmImageRepositoryCredentials.fromJson(reader);
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedGalleryImageProperties.identifier = GalleryImageIdentifier.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedGalleryImageProperties.version = GalleryImageVersion.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryImageProperties.provisioningState = ProvisioningStateEnum.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedGalleryImageProperties.status = GalleryImageStatus.fromJson(reader);
                    continue;
                }
                if ("sourceVirtualMachineId".equals(fieldName)) {
                    deserializedGalleryImageProperties.sourceVirtualMachineId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageProperties;
        });
    }
}

