/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.StorageContainerInner;
import java.io.IOException;
import java.util.List;

public final class StorageContainerListResult
implements JsonSerializable<StorageContainerListResult> {
    private List<StorageContainerInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(StorageContainerListResult.class);

    private StorageContainerListResult() {
    }

    public List<StorageContainerInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model StorageContainerListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static StorageContainerListResult fromJson(JsonReader jsonReader) throws IOException {
        return (StorageContainerListResult)jsonReader.readObject(reader -> {
            StorageContainerListResult deserializedStorageContainerListResult = new StorageContainerListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedStorageContainerListResult.value = value = reader.readArray(reader1 -> StorageContainerInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedStorageContainerListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageContainerListResult;
        });
    }
}

