/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.NetworkSecurityGroupInner;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityGroupListResult
implements JsonSerializable<NetworkSecurityGroupListResult> {
    private List<NetworkSecurityGroupInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityGroupListResult.class);

    private NetworkSecurityGroupListResult() {
    }

    public List<NetworkSecurityGroupInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model NetworkSecurityGroupListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityGroupListResult)jsonReader.readObject(reader -> {
            NetworkSecurityGroupListResult deserializedNetworkSecurityGroupListResult = new NetworkSecurityGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNetworkSecurityGroupListResult.value = value = reader.readArray(reader1 -> NetworkSecurityGroupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNetworkSecurityGroupListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupListResult;
        });
    }
}

