/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.NetworkInterfaceInner;
import java.io.IOException;
import java.util.List;

public final class NetworkInterfaceListResult
implements JsonSerializable<NetworkInterfaceListResult> {
    private List<NetworkInterfaceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkInterfaceListResult.class);

    private NetworkInterfaceListResult() {
    }

    public List<NetworkInterfaceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model NetworkInterfaceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceListResult)jsonReader.readObject(reader -> {
            NetworkInterfaceListResult deserializedNetworkInterfaceListResult = new NetworkInterfaceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNetworkInterfaceListResult.value = value = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNetworkInterfaceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceListResult;
        });
    }
}

