/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.VirtualMachineInstancesClient;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.VirtualMachineInstanceInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.implementation.VirtualMachineInstanceImpl;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstance;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstanceUpdateRequest;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualMachineInstances;

public final class VirtualMachineInstancesImpl
implements VirtualMachineInstances {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineInstancesImpl.class);
    private final VirtualMachineInstancesClient innerClient;
    private final AzureStackHciVmManager serviceManager;

    public VirtualMachineInstancesImpl(VirtualMachineInstancesClient innerClient, AzureStackHciVmManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VirtualMachineInstance> getWithResponse(String resourceUri, Context context) {
        Response<VirtualMachineInstanceInner> inner = this.serviceClient().getWithResponse(resourceUri, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualMachineInstanceImpl((VirtualMachineInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualMachineInstance get(String resourceUri) {
        VirtualMachineInstanceInner inner = this.serviceClient().get(resourceUri);
        if (inner != null) {
            return new VirtualMachineInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualMachineInstance createOrUpdate(String resourceUri, VirtualMachineInstanceInner resource) {
        VirtualMachineInstanceInner inner = this.serviceClient().createOrUpdate(resourceUri, resource);
        if (inner != null) {
            return new VirtualMachineInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualMachineInstance createOrUpdate(String resourceUri, VirtualMachineInstanceInner resource, Context context) {
        VirtualMachineInstanceInner inner = this.serviceClient().createOrUpdate(resourceUri, resource, context);
        if (inner != null) {
            return new VirtualMachineInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualMachineInstance update(String resourceUri, VirtualMachineInstanceUpdateRequest properties) {
        VirtualMachineInstanceInner inner = this.serviceClient().update(resourceUri, properties);
        if (inner != null) {
            return new VirtualMachineInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualMachineInstance update(String resourceUri, VirtualMachineInstanceUpdateRequest properties, Context context) {
        VirtualMachineInstanceInner inner = this.serviceClient().update(resourceUri, properties, context);
        if (inner != null) {
            return new VirtualMachineInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceUri) {
        this.serviceClient().delete(resourceUri);
    }

    @Override
    public void delete(String resourceUri, Context context) {
        this.serviceClient().delete(resourceUri, context);
    }

    @Override
    public PagedIterable<VirtualMachineInstance> list(String resourceUri) {
        PagedIterable<VirtualMachineInstanceInner> inner = this.serviceClient().list(resourceUri);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualMachineInstanceImpl((VirtualMachineInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualMachineInstance> list(String resourceUri, Context context) {
        PagedIterable<VirtualMachineInstanceInner> inner = this.serviceClient().list(resourceUri, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualMachineInstanceImpl((VirtualMachineInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public void start(String resourceUri) {
        this.serviceClient().start(resourceUri);
    }

    @Override
    public void start(String resourceUri, Context context) {
        this.serviceClient().start(resourceUri, context);
    }

    @Override
    public void stop(String resourceUri) {
        this.serviceClient().stop(resourceUri);
    }

    @Override
    public void stop(String resourceUri, Context context) {
        this.serviceClient().stop(resourceUri, context);
    }

    @Override
    public void restart(String resourceUri) {
        this.serviceClient().restart(resourceUri);
    }

    @Override
    public void restart(String resourceUri, Context context) {
        this.serviceClient().restart(resourceUri, context);
    }

    @Override
    public void pause(String resourceUri) {
        this.serviceClient().pause(resourceUri);
    }

    @Override
    public void pause(String resourceUri, Context context) {
        this.serviceClient().pause(resourceUri, context);
    }

    @Override
    public void save(String resourceUri) {
        this.serviceClient().save(resourceUri);
    }

    @Override
    public void save(String resourceUri, Context context) {
        this.serviceClient().save(resourceUri, context);
    }

    private VirtualMachineInstancesClient serviceClient() {
        return this.innerClient;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }
}

