/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.azurestackhci.vm.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.azurestackhci.vm.AzureStackHciVmManager;
import com.azure.resourcemanager.azurestackhci.vm.fluent.models.VirtualHardDiskInner;
import com.azure.resourcemanager.azurestackhci.vm.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.azurestackhci.vm.models.ExtendedLocation;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDisk;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskUploadRequest;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDiskUploadResponse;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDisksUpdateProperties;
import com.azure.resourcemanager.azurestackhci.vm.models.VirtualHardDisksUpdateRequest;
import java.util.Collections;
import java.util.Map;

public final class VirtualHardDiskImpl
implements VirtualHardDisk,
VirtualHardDisk.Definition,
VirtualHardDisk.Update {
    private VirtualHardDiskInner innerObject;
    private final AzureStackHciVmManager serviceManager;
    private String resourceGroupName;
    private String virtualHardDiskName;
    private VirtualHardDisksUpdateRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public VirtualHardDiskProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VirtualHardDiskInner innerModel() {
        return this.innerObject;
    }

    private AzureStackHciVmManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualHardDiskImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public VirtualHardDisk create() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualHardDisks().createOrUpdate(this.resourceGroupName, this.virtualHardDiskName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VirtualHardDisk create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualHardDisks().createOrUpdate(this.resourceGroupName, this.virtualHardDiskName, this.innerModel(), context);
        return this;
    }

    VirtualHardDiskImpl(String name, AzureStackHciVmManager serviceManager) {
        this.innerObject = new VirtualHardDiskInner();
        this.serviceManager = serviceManager;
        this.virtualHardDiskName = name;
    }

    @Override
    public VirtualHardDiskImpl update() {
        this.updateProperties = new VirtualHardDisksUpdateRequest();
        return this;
    }

    @Override
    public VirtualHardDisk apply() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualHardDisks().update(this.resourceGroupName, this.virtualHardDiskName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public VirtualHardDisk apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualHardDisks().update(this.resourceGroupName, this.virtualHardDiskName, this.updateProperties, context);
        return this;
    }

    VirtualHardDiskImpl(VirtualHardDiskInner innerObject, AzureStackHciVmManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.virtualHardDiskName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualHardDisks");
    }

    @Override
    public VirtualHardDisk refresh() {
        this.innerObject = (VirtualHardDiskInner)((Object)this.serviceManager.serviceClient().getVirtualHardDisks().getByResourceGroupWithResponse(this.resourceGroupName, this.virtualHardDiskName, Context.NONE).getValue());
        return this;
    }

    @Override
    public VirtualHardDisk refresh(Context context) {
        this.innerObject = (VirtualHardDiskInner)((Object)this.serviceManager.serviceClient().getVirtualHardDisks().getByResourceGroupWithResponse(this.resourceGroupName, this.virtualHardDiskName, context).getValue());
        return this;
    }

    @Override
    public VirtualHardDiskUploadResponse upload(VirtualHardDiskUploadRequest body) {
        return this.serviceManager.virtualHardDisks().upload(this.resourceGroupName, this.virtualHardDiskName, body);
    }

    @Override
    public VirtualHardDiskUploadResponse upload(VirtualHardDiskUploadRequest body, Context context) {
        return this.serviceManager.virtualHardDisks().upload(this.resourceGroupName, this.virtualHardDiskName, body, context);
    }

    @Override
    public VirtualHardDiskImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public VirtualHardDiskImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public VirtualHardDiskImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public VirtualHardDiskImpl withProperties(VirtualHardDiskProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public VirtualHardDiskImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public VirtualHardDiskImpl withProperties(VirtualHardDisksUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

